#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/NlVcDD

// Code by Flopine

// Thanks to wsmind, leon, XT95, lsdlive, lamogui, 
// Coyhot, Alkama,YX, NuSan, slerpy, wwrighter 
// BigWings, FabriceNeyret and Blackle for teaching me

// Thanks LJ for giving me the spark :3

// Thanks to the Cookie Collective, which build a cozy and safe environment for me 
// and other to sprout :)  
// https://twitter.com/CookieDemoparty


#define time iTime
#define PI acos(-1.)
#define TAU (2.*PI)
#define hr vec2(1., sqrt(3.))

#define circle(p,s) (length(p)-s)
#define hex(p,s) ( max(abs(p.x), dot(abs(p), normalize(hr)))-s )
#define sm(t,v) smoothstep(t, t*1.2,v)

#define hash21(x) fract(sin(dot(x, vec2(164.5,234.1)))*594.5)
#define hash11(x) fract(sin(x)*6497.5)

#define dt(sp,off) fract((time+off)*sp)

vec4 hgrid (vec2 uv)
{
    vec2 ga = mod(uv,hr)-hr*.5, gb = mod(uv-hr*.5, hr)-hr*.5, 
    guv = (dot(ga,ga)<dot(gb,gb))?ga:gb,
    gid = uv-guv;
    return vec4(guv,gid);
}

float extrude (vec3 p, float d, float h)
{
    vec2 q = vec2(d, abs(p.z)-h);
    return min(0., max(q.x,q.y))+length(max(q,0.));
}

float truchet (vec2 uv, float w, float sdfid, bool back)
{
    vec4 hg = hgrid(uv);
    vec2 uu = hg.xy, id = hg.zw; 
    uu.x *= (hash21((id+1.+sdfid)*.1)<.5)?-1.:1.;

    float s = (uu.x*sqrt(3.)>-uu.y)?1.:-1.;
    float diag;
    if (back) diag = sm(0.01,abs(uu.y + uu.x*sqrt(3.))); 
    else diag = abs(uu.y + uu.x*sqrt(3.)); 
    
    uu -= vec2(1., 1./sqrt(3.))*s*.5;
    float contour; 
    if (back) contour = sm(0.02,abs(circle(uu,0.29))); 
    else contour = abs(circle(uu,sqrt(3.)/6.));
    contour *= diag;
    
    return contour-w;
}

float g1=0.; float sid;
float SDF (vec3 p)
{
    p.z += time;
    float per = 2.;
    sid = floor(p.z/per); 
    p.z = mod(p.z, per)-per*.5;
    float d =  extrude(p.xyz, truchet(p.xy+.5, sin(length(p.xy*3.)-dt(.5,sid*.2)*TAU)*.02+.01, sid*.5, false), 0.1);
    g1 += 0.01/(0.01+d*d);
    return d;
}


void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*fragCoord.xy-iResolution.xy)/ iResolution.y;

    float dither = hash21(uv);
    vec3 ro = vec3(0.001,0.001,-5.), rd=normalize(vec3(uv,1.)),p=ro,
    col = clamp(1.-vec3(truchet(uv*3.,0.01,1.,true)),0.,1.);

    bool hit = false; float shad;

    for (float i=0.; i<50.; i++)
    {
        float d = SDF(p);
        if (abs(d)<0.001)
        {
            hit = true; shad=i/64.; break;
        }
        d *= 0.99+dither*0.05;
        p += d*rd;
    }
    
    if (hit)
    {
        col = vec3(1.-shad);
    }
    col += g1*vec3(0.9,0.4,0.)*0.03;
    
    fragColor = vec4(col,1.);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


